<?php

declare(strict_types=1);

namespace Mirakl\MMP\OperatorShop\Request\Payment\Invoice;

use Mirakl\Core\Domain\DateRangeTrait;
use Mirakl\Core\Request\AbstractRequest;
use Mirakl\Core\Request\PageableTrait;
use Mirakl\Core\Request\SortableTrait;
use Mirakl\MMP\OperatorShop\Domain\Collection\Invoice\InvoiceCollection;

/**
 * (IV01) List invoices
 * Note: this resource supports pagination and will return 10 invoices
 * Type of the accounting document for filtering.
 * Default value is AUTO_INVOICE which represent invoices generated by shop payment.
 *
 * @method string   getCurrency()
 * @method $this    setCurrency(string $currency) Currency ISO code for filtering
 * @method string[] getIssuingUserTypes() Any of OPERATOR, BATCH, PARTNER
 * @method $this    setIssuingUserTypes(string[] $issuingUserTypes)
 * @method string   getPaymentStatus()
 * @method $this    setPaymentStatus(string $paymentStatus)
 * @method string   getPspName()
 * @method $this    setPspName(string $pspName)
 * @method string   getType()
 * @method $this    setType(string $type) One of ALL, AUTO_INVOICE, MANUAL_INVOICE, MANUAL_CREDIT
 */
abstract class AbstractGetInvoicesRequest extends AbstractRequest
{
    use DateRangeTrait;
    use PageableTrait;
    use SortableTrait;

    /**
     * @var string
     */
    protected $endpoint = '/invoices';

    /**
     * @var array
     */
    public $queryParams = [
        'currency',
        'end_date',
        'issuing_user_types',
        'payment_status',
        'start_date',
        'type',
        'psp_name'
    ];

    /**
     * @inheritdoc
     */
    public function getResponseDecorator()
    {
        return InvoiceCollection::decorator('invoices');
    }
}
