<?php

declare(strict_types=1);

namespace Mirakl\MMP\Common\Domain;

use Mirakl\Core\Domain\MiraklObject;
use Mirakl\MMP\Common\Domain\Collection\Evaluation\AssessmentCollection;
use Mirakl\MMP\Common\Domain\Evaluation\EvaluationReply;

/**
 * @method AssessmentCollection getAssessments()
 * @method $this                setAssessments(array|AssessmentCollection $assessments)
 * @method string               getCustomerId()
 * @method $this                setCustomerId(string $id)
 * @method string               getComment()
 * @method $this                setComment(string $comment)
 * @method \DateTime            getDate()
 * @method $this                setDate(\DateTime $date)
 * @method string               getFirstname()
 * @method $this                setFirstname(string $firstname)
 * @method int                  getGrade()
 * @method $this                setGrade(int $grade)
 * @method string               getLastname()
 * @method $this                setLastname(string $lastname)
 * @method \DateTime            getLastUpdatedDate()
 * @method $this                setLastUpdatedDate(\DateTime $lastUpdatedDate)
 * @method EvaluationReply      getReply()
 * @method $this                setReply(EvaluationReply $reply)
 * @method bool                 getVisible()
 * @method $this                setVisible(bool $visible)
 * @method bool                 isVisible()
 */
class Evaluation extends MiraklObject
{
    /**
     * @var array
     */
    protected static $dataTypes = [
        'assessments' => [AssessmentCollection::class, 'create'],
        'reply'       => [EvaluationReply::class, 'create'],
    ];
}
